/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core;

import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.AbstractGitRepositoryListener;
import com.aptana.git.core.model.BranchChangedEvent;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoriesListener;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.core.model.IndexChangedEvent;
import com.aptana.git.core.model.PullEvent;
import com.aptana.git.core.model.RepositoryAddedEvent;
import com.aptana.git.core.model.RepositoryRemovedEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GitProjectRefresher
extends AbstractGitRepositoryListener
implements IGitRepositoriesListener {
    GitProjectRefresher() {
    }

    @Override
    public void branchChanged(BranchChangedEvent e) {
        IStatus result = e.getRepository().execute(GitRepository.ReadWrite.READ, "diff", "--name-only", e.getOldBranchName(), e.getNewBranchName());
        if (result != null && result.isOK()) {
            String[] lines;
            ArrayList<IFile> files = new ArrayList<IFile>();
            String output = result.getMessage();
            String[] stringArray = lines = output.split("\r\n?|\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line != null && line.trim().length() != 0) {
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(e.getRepository().workingDirectory().append(line));
                    files.add(file);
                }
                ++n2;
            }
            this.refreshResources(files, 0);
        } else {
            this.refreshAffectedProjects(e.getRepository());
        }
    }

    @Override
    public void pulled(PullEvent e) {
        this.refreshAffectedProjects(e.getRepository());
    }

    @Override
    public void indexChanged(IndexChangedEvent e) {
        this.refreshResources(e.getFilesWithChanges(), 0);
    }

    private void refreshAffectedProjects(GitRepository repo) {
        HashSet<IProject> affectedProjects = new HashSet<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            GitRepository other = this.getRepositoryManager().getAttached(project);
            if (other != null && other.equals(repo)) {
                affectedProjects.add(project);
            }
            ++n2;
        }
        this.refreshResources(affectedProjects, 2);
    }

    private IGitRepositoryManager getRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }

    private void refreshResources(final Collection<? extends IResource> resources, final int depth) {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob("Refresh projects"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                int work = 100 * resources.size();
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)work);
                for (IResource resource : resources) {
                    File dir;
                    if (sub.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (resource == null) continue;
                    if (resource.getType() == 4 && !(dir = resource.getLocation().toFile()).exists()) {
                        block5: {
                            try {
                                resource.getProject().close((IProgressMonitor)sub.newChild(100));
                            }
                            catch (CoreException e) {
                                if (e.getStatus().getSeverity() <= 2) break block5;
                                throw e;
                            }
                        }
                        File dotProject = new File(dir, ".project");
                        if (!dotProject.delete()) continue;
                        dir.delete();
                        continue;
                    }
                    resource.refreshLocal(depth, (IProgressMonitor)sub.newChild(100));
                }
                sub.done();
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setUser(false);
        job.setPriority(30);
        job.schedule();
    }

    @Override
    public void repositoryAdded(RepositoryAddedEvent e) {
        e.getRepository().addListener(this);
    }

    @Override
    public void repositoryRemoved(RepositoryRemovedEvent e) {
        e.getRepository().removeListener(this);
    }
}

